#include "fivewin.ch"

STATIC c_path, c_path1, nTextCol

FUNCTION MAIN()
LOCAL oDlg, oBrw, aImage, oFont1, oGet, oTestBtn, oBrush, c_path, c_path1
LOCAL oChk, lCheck := .T., oRadio, nTLevel := 1
 LOCAL cGet := " this is a GET" + CRLF + " border-test", oSay, oBtn
LOCAL aSample := { { "First row one",  "First row two" },;
                      { "Second row one", "Second row two" },;
                      { "Third row one",  "Third row two" },;
                      { "Fourth row one", "Fourth row two" } }

c_path := cFilePath(GetModuleFileName( GetInstance() ) )
c_path1 := c_Path + "BITMAPS\"

DEFINE FONT oFont NAME "Arie" SIZE 0, -14 BOLD

DEFINE DIALOG oDlg SIZE 600, 490 PIXEL TRUEPIXEL FONT oFont TITLE "Border - test => Release 2.1"

DEFINE BRUSH oBrush COLOR 16711680 STRETCH
oDlg:SetBrush( oBrush )
RELEASE BRUSH oBrush

@ 40,40  XBROWSE oBrw SIZE 340, 160 PIXEL OF oDlg ;
DATASOURCE  aSample ;
FOOTERS CELL LINES ;
BACKGROUND( c_path1 + "Blustone.Bmp" ) 

oBrw:nMarqueeStyle := MARQSTYLE_HIGHLCELL

WITH OBJECT oBrw
        :lContrastClr := .F.
        :CreateFromCode()
END

@ 250, 40 BTNBMP oTestBtn OF oDlg ;
SIZE 140, 60 PIXEL 2007 ; // B / H
PROMPT " &Test-button " ;
FONT oFont  ;
LEFT
SetTextColor( oTestBtn:hDC, 0 )
oTestBtn:bClrGrad = { | lMouseOver | If( ! lMouseOver,;
	{ { 0.5, 10526975, 16777215 }, ;
	  { 0.5, 16777215, 10526975 } }, ;
	{ { 0.5, 16768185 , 10526975 }, ;
	   { 0.5, 10526975, 16768185 } } ) }
oTestBtn:cToolTip =  { "BORDER-tests","TEST", 1, CLR_BLACK, 14089979 }
oTestBtn:SetColor( 0, )

@ 250, 230 GET oGet VAR  cGet  SIZE 155, 60  OF oDlg  MULTILINE Font oFont PIXEL UPDATE 

@ 355, 230 SAY oSay PROMPT " Bordertest on SAY" OF oDlg SIZE 155, 25  PIXEL BORDER UPDATE
oSay:SetColor( 16777215 ) 
oSay:lTransparent :=  .T.

@ 425, 230 CHECKBOX oChk VAR lCheck PROMPT " Checkbox-border" SIZE 155, 25 OF oDlg PIXEL UPDATE
oChk:lTransparent :=  .T.
oChk:SetColor( 16777215 ) 

@ 45, 440 RADIO oRadio VAR nTLevel OF oDlg  PIXEL UPDATE ;
ITEMS "Position &1", "Position &2", "Position &3", "Position &4", "Position &5", "Position &6" _3D SIZE 100, 25 ;
HELPID 100, 101, 102, 103, 104, 105
AEval( oRadio:aItems, { | oRad | oRad:lTransparent := .T., ;
	                                              oRad:SetColor( 16777215 ) } )

oDlg:bPainted    := < |hDC|
	//DRAW_BORDER(Object, hDC, oSection, aCors, nLineType, nColor, ;
	//		nPensize, nRound, nTransp, nShadow, nDistance )
	DRAW_BORDER(oDlg, hDC, oBrw, , 2, 16777215, 5,15, 100,0, 0 )
	DRAW_BORDER(oDlg, hDC, oTestBtn, , 2, 16777215, 5, 15, 100,0, 0 )
	DRAW_BORDER(oDlg, hDC, oGet, , 2, 16777215, 5,15, 100,0, 0 )
	DRAW_BORDER(oDlg, hDC, oSay, , 2,16777215, 5, 15, 100, 0, 0 )
	DRAW_BORDER(oDlg, hDC, oChk, , 2,16777215, 5, 15, 100,0, 0 )
	DRAW_BORDER(oDlg, hDC, , { 40, 430, 125, 160 }, 2,16777215, 5, 15, 100,0, 0 )
	DRAW_BORDER(oDlg, hDC, , { 355, 40, 140, 100 }, 2,16777215, 5, 15, 100,0, 0 )

	RETURN NIL
>

COLOR_SET(oRadio, oSay)

@ 420, 445 BTNBMP oSysBtn RESOURCE "Exit" OF oDlg ;
SIZE 120, 40 PIXEL 2007 BORDER ; // B / H
PROMPT " &Exit " ; 
ACTION oDlg:End() ;
FONT oFont  ;
LEFT
oSysBtn:bClrGrad = { | lMouseOver | If( ! lMouseOver,; 
	{ { 0.5, 10526975, 16777215 }, ;
	  { 0.5, 16777215, 10526975 } }, ;
	{ { 0.5, 16768185 , 10526975 }, ;
	   { 0.5, 10526975, 16768185 } } ) }
oSysBtn:cToolTip =  { "Exit BORDER-tests","EXIT", 1, CLR_BLACK, 14089979 }
oSysBtn:SetColor( 0, )

ACTIVATE DIALOG oDlg CENTER

RELEASE FONT oFont

RETURN NIL

// --------------------------

FUNCTION COLOR_SET(oRadio, oSay)
LOCAL I

AEval( oRadio:aItems, { | oRad | oRad:lTransparent := .T., ;
	                           oRad:SetColor( 16777215 ) } )

oSay:SETCOLOR( 16777215 )
oSay:Refresh()

RETURN NIL


// ----------------------------------

FUNCTION DRAW_BORDER(Object, hDC, oSection, aCors, nLineType, nColor, ;
                                                   nPensize, nRound, nTransp, nShadow, nDistance )
LOCAL oGraphics, oPen, nRed, nGreen, nBlue
LOCAL n, nLEFT, nTOP, nWIDTH, nHEIGHT, nPen

oGraphics   := Graphics():New( hDC ) 
nRed            := nRGBRed( nColor )
nGreen        := nRGBGreen( nColor )
nBlue           := nRGBBlue( nColor )

IF nLineType = 1        // line
     IF aCors <> NIL // free position
          nTOP	:= aCors[1] - nDistance
          nLEFT	:= aCors[2] - nDistance
          nWIDTH	:= aCors[3] + 2 * nDistance
          nHEIGHT	:= aCors[4] + 2 * nDistance
     ELSE
          nTOP	:= oSection:nTop - nPensize + nShadow
          nLEFT	:= oSection:nLeft - nPensize + nShadow
          nWIDTH	:= oSection:nWidth + 2 * nPensize - nShadow
          nHEIGHT	:= oSection:nHeight + 2 * nPensize - nShadow
     ENDIF
     oPen := Pen():New( nTransp, nRed, nGreen, nBlue, nPensize, .T. )
     oGraphics:DrawRoundRect( oPen,  ,nLeft, nTop, nWidth, nHeight, nRound ) 
ELSEIF  nLineType = 2                  // glow
     nPen             := nPensize * 0.5
     IF aCors <> NIL // free position
          nTOP	:= aCors[1]
          nLEFT	:= aCors[2]
          nWIDTH	:= aCors[3]
          nHEIGHT	:= aCors[4]
     ELSE
          nTOP	:= oSection:nTop - nPen + nShadow  - nDistance
          nLEFT	:= oSection:nLeft - nPen + nShadow  - nDistance
          nWIDTH	:= oSection:nWidth + 2 * nPen  - nShadow + 2 * nDistance
          nHEIGHT	:= oSection:nHeight + 2 * nPen - nShadow + 2 * nDistance
     ENDIF
     nTransp	:= 255
     oPen		:= Pen():New( nTransp, nRed, nGreen, nBlue, nPen )
     FOR n = 1 to 6
          oGraphics:DrawRoundRect( oPen,  ,nLeft, nTop, nWidth, nHeight, nRound )
          nTop	:= nTop - nPen
          nLeft	:= nLeft - nPen  
          nWidth	:= nWidth + 2 * nPen 
          nHeight	:= nHeight + 2 * nPen 
          nRound	:= nRound + 2 * nPen 
          nTransp	:= nTransp - 41
          oPen:setcolor( nTransp, nRed, nGreen, nBlue ) // transparent change
     NEXT 
ENDIF

oPen:Destroy()
oGraphics:Destroy()

RETURN NIL